package gov.va.vinci.dart.biz;

import gov.va.vinci.dart.common.ValidationHelper;
import gov.va.vinci.dart.common.exception.ValidationException;
import gov.va.vinci.dart.service.DartObjectFactory;

import java.util.Calendar;
import java.util.Date;
import java.util.List;

import javax.persistence.DiscriminatorValue;
import javax.persistence.Entity;

@Entity
@DiscriminatorValue("3")
public class OperationalStudy extends Activity {

	private static final Calendar CAL_1900 = Calendar.getInstance();
	
	static {
		CAL_1900.set(1900, 0, 1);
	}
	
	
	OperationalStudy(){}
	

	public static OperationalStudy create(final String name, final Date startDate, final Date endDate, final String officialName, final String createdBy, final int requestorId) throws ValidationException {
		OperationalStudy study = new OperationalStudy();
		
		ValidationHelper.required("Created By", createdBy);
		ValidationHelper.validateSize("Created By", createdBy, 1, 32);
		
		study.setCreatedOn(new Date());
		study.setCreatedBy(createdBy);
		
		study.modify(name, startDate, endDate, officialName, createdBy, requestorId);
		
		DartObjectFactory.getInstance().getOperationalStudyDAO().save(study);
		
		return study;
	}
	
	public void modify(final String name, final Date startDate, final Date endDate, final String officialName, final String updatedBy, final int requestorId) throws ValidationException {
		validateModify(name, startDate, endDate, officialName);
		
		this.name = name;
		this.startDate = startDate;
		this.endDate = endDate;
		this.officialName = officialName;
		this.updatedBy = updatedBy;
		this.updatedOn = new Date();
	}
	
	public static List<OperationalStudy> listAll() {
		return DartObjectFactory.getInstance().getOperationalStudyDAO().listAll();
	}
	
	public static OperationalStudy findById(final int activityId) {
		return DartObjectFactory.getInstance().getOperationalStudyDAO().findById(activityId);
	}
	
	public static OperationalStudy findByShortName(final String name) throws ValidationException {
		ValidationHelper.required("Operational Study Sort Name", name);
		ValidationHelper.validateSize("Operational Study Sort Name", name, 1, 1024);
		
		return DartObjectFactory.getInstance().getOperationalStudyDAO().findByShortName(name);
	}
		
	private void validateModify(final String name, final Date startDate, final Date endDate, final String officialName) throws ValidationException {

		//
		// business rules require that name not be required...
		//ValidationHelper.required("Name", name);
		ValidationHelper.validateSize("Name", name, 0, 1024);
		ValidationHelper.required("Official Name", officialName);
		ValidationHelper.validateSize("Official Name", officialName, 0, 1024);
		
		if (startDate != null) {
			if (CAL_1900.getTime().after(startDate)) {
				throw new ValidationException("Start date must be after Jan 1, 1900");
			}
		}
		
		if (endDate != null) {
			if (CAL_1900.getTime().after(endDate)) {
				throw new ValidationException("End date must be after Jan 1, 1900");
			}
		}

		if (startDate != null && endDate != null) {
			if (startDate.after(endDate)) {
				throw new ValidationException("Start date must be before end date.");
			}
		}
	}

	// necessary to use (List<OperationalStudy>).contains()
	@Override
	public boolean equals(Object obj) {
		if (obj == null) {
			return false;
		}
		
		if ((obj instanceof OperationalStudy) == false) {
			return false;
		}
		
		OperationalStudy rs2 = (OperationalStudy)obj;
		return rs2.getId() == this.getId();
	}	

}
 